/*************************************************
author: RuanShengQiang
date: 2017/3/24
**************************************************/
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

//to amp "amp" times the picture;
static vec2 myMod(vec2 x, float y)
{
	return x-y * floor (x/y);
}

static vec2 scale(vec2 uv, vec2 center, vec2 amp)
{

	return (uv - center)*amp + center;

}

static vec2 _rotate(vec2 uv, vec2 center, float theta)
{
	vec2 temp;
	temp.x = dot((vec2)(cos(theta), -sin(theta)), uv - center);
	temp.y = dot((vec2)(sin(theta), cos(theta)), uv - center);
	return(temp);
}

static vec2 warp(vec2 uv, vec2 center, float strength, float r, float amp)
{

	return myMod(center + (uv - center) / (strength*r*r + strength*r + 1.0f), 1.0f / amp);
}

static vec2 mirror(vec2 uv)
{
	vec2 parity = myMod(floor(uv),2.0f);
	vec2 sign = -2.0f*parity+1.0f;
	return myMod( 2.0f*parity+sign*myMod(uv,1.0f),1.0f);
}

static 	vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

static float4 blur(image2d_t input, __global FilterParam* param, vec2 uv, vec2 dir, int Samples, float processMB, vec2 rollDir)
{

	vec2 temp1;
	vec2 temp2;
	vec2 temp3;
	float2 diver = dir*processMB/(float)(Samples);
	vec4 color = (vec4)(0.0f,0.0f,0.0f,1.0f);
	for (int i = 0; i < Samples; i += 2) //operating at 2 samples for better performance
	{
		temp1 = mirror( uv + (float)(i) * diver +rollDir );
		color += INPUT(input, param, temp1);
		temp1 = mirror( uv + (float)(i+1) * diver +rollDir );
		color += INPUT(input, param, temp1);
	}
	return color;
}


__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 uv = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;
	float prop = resolution.y / resolution.x;
	float iGlobalTime = progress;
	
	const float sampleSize = 32.0f;
	const int Samples = 16;//multiple of 2

	vec2 center = (vec2)(0.5f,0.0f);
	vec2 dir = (vec2)(1.0f,0.0f);
	float r = length(dir);
	
	float processColorSp = pow(cos(PI*(iGlobalTime-0.5f)),2.0f)*0.001f;
	float processMB = iGlobalTime*0.2f;// the blur trend is same as scale
	
	float temp = cos(PI*3.0f/2.0f*(iGlobalTime-0.33333f));
	vec2 rollDir = 0.5f*(vec2)(0.0f,temp*temp);
	//time > 0.5
	float processWarpR = pow(cos(PI*(iGlobalTime-0.5f)),2.0f);// warp amp
	float processScalR = 4.0f*(iGlobalTime-1.0f)*(iGlobalTime-1.0f);
	float processMBR=0.8f*(iGlobalTime-1.0f)*(iGlobalTime-1.0f);
	
	if (iGlobalTime<0.3333333333333f)
    { 	
		//float HoriScale = 9.0f*iGlobalTime*iGlobalTime+3.0f*iGlobalTime;
		float HoriScale = pow( (3.3333333333f*iGlobalTime),7.0f)*2.0f;
		float vertiScale = 0.3f*uv.y*HoriScale+1.0f;
		//vec2 amp = vec2(1.0f/(1.0f+uv.y*3.3*boxFlit),1.0f/(1.0f+uv.y*0.3*boxFlit));
		vec2 amp = (vec2)(1.0f/(1.0f+uv.y*HoriScale),1.0f/vertiScale);
		//vec2 amp = vec2(1.0f,1.0f);
		uv = scale(uv,center,amp)+(vec2)(0.0f,HoriScale*0.1f);
		
		float bottom = 1.0f;
		float top = (1.0f+uv.y*HoriScale);
		float tan = vertiScale/((top - bottom)/2.0f+0.000001f) ;
		float High = 0.5f*bottom*tan;
		vec2 center =(vec2)(0.5f,-High);
		dir = normalize(uv-center);
		
		vec4 color = blur(input1, param, uv, dir,Samples, processMB,(vec2)(0.0f));
		write_imagef(dstImg, (int2)(w, textH - h -1), color/(float)(Samples));
    }
	else {
	
			//rollDir = vec2( 0.0f,0.99999*sin(2.3561944*(iGlobalTime-0.33333333)));
			float temp = 1.5f*(iGlobalTime-0.3333333333333f) - 1.0f;
			rollDir = (vec2)( 0.0f,1.0f-temp*temp*temp*temp)*2.0f;
		
			vec2 amp = (vec2)(1.0f/(1.0f+2.0f*(1.0f-uv.y)*(1.0f-rollDir.y/2.0f)),1.0f);
	
			uv = (uv - (vec2)(0.5f))*amp.x+(vec2)(0.5f);

			float bottom = 1.0f/amp.x;
			float top = 1.0f;
			vec2 center =(vec2)(0.5f,1.0f/(bottom-top+0.0000001f)+1.0f);
			dir = normalize(uv-center);
			
			vec4 color = blur(input2, param, uv, dir,Samples, processMBR,(vec2)(0.0f));
			write_imagef(dstImg, (int2)(w, textH - h -1), color/(float)(Samples));
	}   
}